/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.util;

import com.ibm.hwmca.fw.pa.ProblemAnalysisManager;
import com.ibm.hwmca.xfw.pa.util.LogListener;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class PaSimulator {
    private static ProblemAnalysisManager problemAnalysisManager = null;
    JDialog dialog;
    JButton cancel;
    JButton enter;
    JTextField tfLogClass;
    JTextField tfLogType;
    JTextField tfUser;
    JTextField tfTimeStamp;
    Listener listener = new Listener();

    public static void main(String[] args) {
        try {
            problemAnalysisManager = ProblemAnalysisManager.getProblemAnalysisManager();
            new PaSimulator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PaSimulator() throws IOException {
        this.dialog = new JDialog((Frame)null, "PA Simulator", true);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(this.listener);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets.top = 5;
        constraints.insets.left = 5;
        constraints.insets.right = 5;
        constraints.anchor = 18;
        JLabel label = new JLabel("LogClass (byte):");
        constraints.gridwidth = -1;
        mainPanel.add((Component)label, constraints);
        this.tfLogClass = new JTextField("00");
        label.setLabelFor(this.tfLogClass);
        Font tfFont = this.tfLogClass.getFont();
        Font monoFont = new Font("Monospaced", tfFont.getStyle(), tfFont.getSize());
        this.tfLogClass.setFont(monoFont);
        this.tfLogClass.setEditable(true);
        this.tfLogClass.setBorder(new EmptyBorder(0, 0, 0, 0));
        constraints.gridwidth = 0;
        constraints.insets.left = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        mainPanel.add((Component)this.tfLogClass, constraints);
        constraints.insets.left = 5;
        constraints.anchor = 17;
        label = new JLabel("LogType (byte):");
        constraints.gridwidth = -1;
        mainPanel.add((Component)label, constraints);
        this.tfLogType = new JTextField("00");
        label.setLabelFor(this.tfLogType);
        this.tfLogType.setFont(monoFont);
        this.tfLogType.setEditable(true);
        this.tfLogType.setBorder(new EmptyBorder(0, 0, 0, 0));
        constraints.gridwidth = 0;
        constraints.insets.left = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        mainPanel.add((Component)this.tfLogType, constraints);
        constraints.insets.left = 5;
        constraints.anchor = 17;
        label = new JLabel("User (short):");
        constraints.gridwidth = -1;
        mainPanel.add((Component)label, constraints);
        this.tfUser = new JTextField("0");
        label.setLabelFor(this.tfUser);
        this.tfUser.setFont(monoFont);
        this.tfUser.setEditable(true);
        this.tfUser.setBorder(new EmptyBorder(0, 0, 0, 0));
        constraints.gridwidth = 0;
        constraints.insets.left = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        mainPanel.add((Component)this.tfUser, constraints);
        constraints.insets.left = 5;
        constraints.anchor = 17;
        label = new JLabel("TimeStamp (long):");
        constraints.gridwidth = -1;
        mainPanel.add((Component)label, constraints);
        this.tfTimeStamp = new JTextField(new Long(System.currentTimeMillis()).toString());
        label.setLabelFor(this.tfTimeStamp);
        this.tfTimeStamp.setFont(monoFont);
        this.tfTimeStamp.setEditable(true);
        this.tfTimeStamp.setBorder(new EmptyBorder(0, 0, 0, 0));
        constraints.gridwidth = 0;
        constraints.insets.left = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        mainPanel.add((Component)this.tfTimeStamp, constraints);
        this.dialog.getContentPane().add((Component)mainPanel, "Center");
        JPanel buttonPanel = new JPanel();
        this.enter = new JButton("Enter");
        this.enter.addActionListener(this.listener);
        buttonPanel.add(this.enter);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this.listener);
        buttonPanel.add(this.cancel);
        this.dialog.getContentPane().add((Component)buttonPanel, "South");
        this.dialog.getRootPane().setDefaultButton(this.cancel);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        Thread showThread = new Thread(){

            public void run() {
                PaSimulator.this.dialog.show();
            }
        };
        showThread.setDaemon(true);
        showThread.start();
    }

    private void processEnter() {
        byte logClass = 0;
        byte logType = 0;
        short user = 0;
        long timestamp = 0L;
        boolean malformedData = false;
        try {
            logClass = Byte.parseByte(this.tfLogClass.getText());
        }
        catch (Exception e) {
            this.tfLogClass.setText("malformed");
            malformedData = true;
        }
        try {
            logType = Byte.parseByte(this.tfLogType.getText());
        }
        catch (Exception e) {
            this.tfLogType.setText("malformed");
            malformedData = true;
        }
        try {
            user = Short.parseShort(this.tfUser.getText());
        }
        catch (Exception e) {
            this.tfUser.setText("malformed");
            malformedData = true;
        }
        try {
            timestamp = Long.parseLong(this.tfTimeStamp.getText());
        }
        catch (Exception e) {
            this.tfTimeStamp.setText("malformed");
            malformedData = true;
        }
        if (malformedData) {
            return;
        }
        System.out.println("Simulator calling LogListener");
        LogListener.handle(logClass, logType, user, timestamp);
    }

    private void processClose() {
        this.dialog.dispose();
        System.exit(0);
    }

    private class Listener
    implements WindowListener,
    ActionListener {
        private Listener() {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            PaSimulator.this.processClose();
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == PaSimulator.this.cancel) {
                PaSimulator.this.processClose();
            } else if (source == PaSimulator.this.enter) {
                PaSimulator.this.processEnter();
            }
        }
    }
}

